#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;

    vector<long long> w(N+1), v(N+1);
    long long vmax = 0;
    for (int i = 1; i <= N; i++) {
        cin >> w[i] >> v[i];
        vmax = max(vmax, v[i]);
    }

    // Edge cases
    if (N == 0 || W <= 0) {
        cout << 0 << "\n\n";
        return 0;
    }
    if (vmax == 0) {
        cout << 0 << "\n\n";
        return 0;
    }

    // Scaling factor K = eps * vmax / N
    // To avoid K=0 due to floating precision, keep it as double but protect.
    double K = eps * (double)vmax / (double)N;
    if (K <= 0) K = 1.0;

    vector<int> vp(N+1);
    long long sumVp = 0;
    for (int i = 1; i <= N; i++) {
        vp[i] = (int)floor((double)v[i] / K);
        if (vp[i] < 0) vp[i] = 0;
        sumVp += vp[i];
    }

    // If scaling collapsed everything to 0 (can happen when eps is huge and values small),
    // just take the single best item that fits.
    if (sumVp == 0) {
        long long bestV = 0;
        int bestI = -1;
        for (int i = 1; i <= N; i++) {
            if (w[i] <= W && v[i] > bestV) {
                bestV = v[i];
                bestI = i;
            }
        }
        if (bestI == -1) {
            cout << 0 << "\n\n";
        } else {
            cout << 1 << "\n" << bestI << "\n";
        }
        return 0;
    }

    const long long INF = (1LL<<62);

    int S = (int)sumVp;
    vector<long long> dp(S+1, INF);
    dp[0] = 0;

    // For reconstruction:
    // parent[s] = previous s' from which we came to s (s' = s - vp[i])
    // takeIdx[s] = item index i used to reach s from parent[s]
    vector<int> parent(S+1, -1), takeIdx(S+1, -1);

    for (int i = 1; i <= N; i++) {
        int add = vp[i];
        if (add == 0) continue; // doesn't help in scaled DP
        for (int s = S; s >= add; s--) {
            if (dp[s - add] == INF) continue;
            long long cand = dp[s - add] + w[i];
            if (cand < dp[s]) {
                dp[s] = cand;
                parent[s] = s - add;
                takeIdx[s] = i;
            }
        }
    }

    // Find best achievable scaled value within weight W
    int bestS = 0;
    for (int s = 0; s <= S; s++) {
        if (dp[s] <= W) bestS = s;
    }

    // Reconstruct chosen items
    vector<int> chosen;
    int cur = bestS;
    while (cur > 0 && takeIdx[cur] != -1) {
        int i = takeIdx[cur];
        chosen.push_back(i);
        cur = parent[cur];
    }
    sort(chosen.begin(), chosen.end());
    chosen.erase(unique(chosen.begin(), chosen.end()), chosen.end());

    cout << (int)chosen.size() << "\n";
    for (int i = 0; i < (int)chosen.size(); i++) {
        if (i) cout << " ";
        cout << chosen[i];
    }
    cout << "\n";
    return 0;
}